/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	MakeRadialDim.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"


HRESULT MakeRadialDim(ILine *circle1)
{
	//	Creates a RadialDim constraint on the given circle

	START_METHOD("MakeRadialDim")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IRadialDim *pRadialDim = NULL;

	status = (GetCLASS(RadialDim))->CreateRadialDim(circle1, &pRadialDim);
	CHECK_RETURN_STATUS(status)

	IConstraint *pConstraint = NULL;

	status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint, pRadialDim), &pConstraint);
	CHECK_RETURN_STATUS(status)

	END_METHOD("MakeRadialDim")
}
